/******************************************************************************
	CListingDirector.c
	
	Methods for the listing files.


	Copyright (C) 1985-1992  New York University
	Copyright (C) 1994 George Washington University
	 
	This file is part of the GWAdaEd system, an extension of the Ada/Ed-C
	system.  See the Ada/Ed README file for warranty (none) and distribution
	info and also the GNU General Public License for more details.


 ******************************************************************************/

#include <Global.h>
#include <Commands.h>
#include <assert.h>
#include <CApplication.h>
#include <CBartender.h>
#include <CDesktop.h>
#include <CDecorator.h>
#include <CDataFile.h>

#include "CListingDirector.h"
#include "CListingPane.h"
#include "CSourceDocument.h"
#include "CMenuWindow.h"
#include "CAdaApp.h"
#include "AppCommands.h"



extern	CApplication *gApplication;	/* The application */
extern	CBartender	*gBartender;	/* The menu handling object */
extern	CDesktop	*gDesktop;		/* The enclosure for all windows */
extern	CDecorator	*gDecorator;	/* Window dressing object	*/


/**** Font Defaults ****/
#define kDefaultFont	monaco
#define kDefaultSize	9


/***
 * IListingDirector
 *
 ***/
 
void CListingDirector::IListingDirector(CSourceDocument *aOwner,
		long numErrors, Msg *ptr)
{
	IDirector(aOwner);
	itsNumErrors = numErrors;
	itsCurrMsg = -1;
	itsErrors = ptr;
}

/****
 *	Dispose
 *
 ****/

void	CListingDirector::Dispose(void)
{
	((CSourceDocument *)itsSupervisor)->ListingClosed();
	inherited::Dispose();
}

/***
 * OpenFile
 *
 ***/

void CListingDirector::OpenFile(SFReply *macSFReply)

{
	CDataFile	*theFile;
	Handle		theData;
	Str63		theName;
	OSErr		theError;

	theFile = new(CDataFile);
	theFile->IDataFile();
	theFile->SFSpecify(macSFReply);
	

	theFile->Open(fsRdWrPerm);
	
	if (theFile->GetLength() > 32000L) {
		ParamText( "\pCan't open a file bigger than 32K.", "\p", "\p", "\p");
		PositionDialog('ALRT', 128);
		InitCursor();
		Alert(128, NULL);

		theFile->Dispose();
		Dispose();
		return;
	}
	

    theData = theFile->ReadAll();     /* ReadAll() creates the handle */

	BuildWindow(theData);
	DisposHandle(theData);

	theFile->GetName(theName);
	theFile->Dispose();

	itsWindow->SetTitle(theName);
	//Activate();
	itsWindow->Select();	/* Don't forget to make the window active */
	//BecomeGopher(TRUE);
}

/****
 *	BuildWindow
 *
 ****/

void	CListingDirector::BuildWindow (Handle theData)
{
	itsWindow = new(CMenuWindow);
	itsWindow->IWindow(WINDculture, FALSE, gDesktop, this);
		/**
		 **	After you create the window, you can use the
		 **	SetSizeRect() message to set the windows maximum
		 **	and minimum size. Be sure to set the max & min
		 **	BEFORE you send a PlaceNewWindow() message to the
		 **	decorator.
		 **
		 ** The default minimum is 100 by 100 pixels. The
		 **	default maximum is the bounds of GrayRgn() (The
		 **	entire display area on all screens.)
		 **
		 **/

	BuildWindowContents();

	if (theData)
		fTextEdit->SetTextHandle(theData);

	// set the font/size into the text edit field
	fTextEdit->SetFontNumber(kDefaultFont);
	fTextEdit->SetFontSize(kDefaultSize);

	// Set non-editable, non-selectable
	fTextEdit->Specify(kNotEditable, kNotSelectable, kNotStylable);

	fTextEdit->SetSelection(0, 0, false);
	fTextEdit->ScrollToSelection();

	gDecorator->PlaceNewWindow(itsWindow);
}


/***
 *	BuildWindowContents
 *
 *	Separated from BuildWindow so that subclass can create
 *	different configurations of the contents of the window
 *
 ***/

void	CListingDirector::BuildWindowContents(void)
{
	CScrollPane		*theScrollPane;
	CTextPane		*theMainPane;
	LongPt			pt;

	theScrollPane = new(CScrollPane);
	theScrollPane->IScrollPane(itsWindow, this, 10, 10, 0, 0,
								sizELASTIC, sizELASTIC,
								TRUE, TRUE, TRUE);

	theScrollPane->FitToEnclFrame(TRUE, TRUE);

	fTextEdit = new(CListingPane);
	((CListingPane *)fTextEdit)->IListingPane(theScrollPane, this);
	itsGopher = fTextEdit;

	theScrollPane->InstallPanorama(fTextEdit);
	SetLongPt(&pt, 0, 0);
	fTextEdit->ScrollTo(&pt, false);
}

/****
 *	UpdateMenus
 *
 *	Set menu state based on current context of this document
 *
 ****/

void	CListingDirector::UpdateMenus(void)
{
	inherited::UpdateMenus();

	if (GetNumErrors() > 0) {
		gBartender->EnableCmd(cmdPreviousError);
		gBartender->EnableCmd(cmdNextError);
	}
	else {
		gBartender->DisableCmd(cmdPreviousError);
		gBartender->DisableCmd(cmdNextError);
	}
}

/***
 * DoCommand
 *
 ***/
 
void	CListingDirector::DoCommand(long theCommand)
{

	switch (theCommand) {
		case cmdPreviousError: {
			Msg cm;		// current message

			itsCurrMsg--;
			if (itsCurrMsg < 0)
				itsCurrMsg = 0;
			cm = itsErrors[itsCurrMsg];

			((CSourceDocument *)itsSupervisor)->SelectFT(cm->msg_line1, cm->msg_col1,
							   cm->msg_line2, cm->msg_col2);
			((CSourceDocument *)itsSupervisor)->ScrollToSelection();

			// Select the window associated with this
			((CSourceDocument *)itsSupervisor)->Select();
			((CListingPane *)fTextEdit)->HilightLines(cm->msg_lineno1,
				cm->msg_lineno2);
			break;
		}

		case cmdNextError: {
			Msg cm;
			long line;
			
			itsCurrMsg++;
			if (itsCurrMsg >= itsNumErrors)
				itsCurrMsg = itsNumErrors - 1;
			cm = itsErrors[itsCurrMsg];

			((CSourceDocument *)itsSupervisor)->SelectFT(cm->msg_line1, cm->msg_col1,
							   cm->msg_line2, cm->msg_col2);
			((CSourceDocument *)itsSupervisor)->ScrollToSelection();

			// Select the window associated with this
			((CSourceDocument *)itsSupervisor)->Select();
			((CListingPane *)fTextEdit)->HilightLines(cm->msg_lineno1,
					cm->msg_lineno2);

			break;
		}

		default:
			inherited::DoCommand(theCommand);
			break;
	}
}


/****
 *	GetOwner
 *
 *	Return collaborator
 *
 ****/

CSourceDocument	*CListingDirector::GetOwner(void)
{
	return (CSourceDocument *)itsSupervisor;
}

/****
 *	GetNumErrors
 *
 *	Return instance variable 'itsNumErrors'
 *
 ****/

long	CListingDirector::GetNumErrors(void)
{
	return itsNumErrors;
}

/****
 *
 *
 ****/

void	CListingDirector::GetNextError(long *fline, long *fcol,
						 long *tline, long *tcol)
{
	long selStart;
	long selEnd;
	Handle text;
	long iOffset, offset, findLen, rplcLen;
	Ptr findStr, rplcStr;

	fTextEdit->GetSelection(&selStart, &selEnd);
	if (selStart == fTextEdit->GetLength())
		selStart = selEnd = 0;

	findStr = "***";
	findLen = 3;
	rplcStr = NULL;
	rplcLen = 0;
	text = fTextEdit->GetTextHandle();
	iOffset = Munger(text, selEnd, findStr, findLen,
						rplcStr, rplcLen);

}

/****
 *
 *
 ****/

void	CListingDirector::GetPrevError(long *fline, long *fcol,
						 long *tline, long *tcol)
{
}

